---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：22-Security CSRF

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **BREACH攻撃防止の技術的正確性**：XOR暗号化によるBREACH対策の説明精度を確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Security/Csrf/CsrfToken.php` - CsrfTokenクラス
- E-02: `src/Symfony/Component/Security/Csrf/CsrfTokenManager.php` - CsrfTokenManagerクラス
- E-03: `src/Symfony/Component/Security/Csrf/CsrfTokenManagerInterface.php` - インターフェース
- E-04: `src/Symfony/Component/Security/Csrf/SameOriginCsrfTokenManager.php` - SameOrigin実装
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CsrfTokenはid+valueの不変オブジェクト | E-01 (21-28行目) | ○ |
| C-02 | valueに#[SensitiveParameter]属性が付与されている | E-01 (26行目) | ○ |
| C-03 | getTokenでストレージ確認後、なければ生成して保存 | E-02 (66-78行目) | ○ |
| C-04 | randomize()で32バイトランダムキーによるXOR暗号化 | E-02 (110-116行目) | ○ |
| C-05 | derandomize()でBase64デコード+XOR復号 | E-02 (118-131行目) | ○ |
| C-06 | isTokenValidでhash_equalsによるタイミングセーフ比較 | E-02 (95-103行目) | ○ |
| C-07 | 名前空間でHTTPS/HTTPを分離 | E-02 (45-63行目) | ○ |
| C-08 | SameOriginCsrfTokenManagerはSec-Fetch-Site、Origin/Referer、ダブルサブミットで検証 | E-04 (116-191行目, 251-306行目) | ○ |
| C-09 | TOKEN_MIN_LENGTHは24文字 | E-04 (60行目) | ○ |
| C-10 | __Host-プレフィクスをHTTPS接続時に付与 | E-04 (289行目) | ○ |
| C-11 | セッションによる検証方式ダウングレード防止 | E-04 (150-170行目) | ○ |
| C-12 | clearCookies, persistStrategy, onKernelResponseは非推奨 | E-04 (194-246行目) | ○ |
| C-13 | XOR暗号化の計算式 | E-02 (110-116, 133-139行目) | ○ |
| C-14 | Cookie名の正規表現バリデーション | E-04 (78-84行目) | ○ |
| C-15 | fallbackCsrfTokenManagerへの委任 | E-04 (91-93, 100-101, 109-110, 118-119行目) | ○ |
| C-16 | BREACH攻撃対策としてのランダム化の有効性 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- BREACH攻撃対策としてのXOR暗号化の有効性に関する外部技術文書
  - 候補：BREACH攻撃に関するセキュリティ論文 / OWASP CSRF Prevention Cheat Sheet

## 5) リスクフラグ（レビュー観点）
- 0: トークン生成・検証のコードフロー - コードと整合
- 0: SameOriginCsrfTokenManagerの検証ロジック - コードと整合
- 1: BREACH攻撃対策の技術的正確性 - セキュリティ専門知識による確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] randomize/derandomizeの処理説明がコードと一致しているか
- [ ] SameOriginCsrfTokenManagerの3段階検証（Sec-Fetch-Site, Origin/Referer, ダブルサブミット）の説明が正確か
- [ ] 非推奨メソッドの記載が最新版と一致しているか
- [ ] __Host-Cookieプレフィクスの適用条件が正しいか
